//Experiment Number:2 
//Write a program to perform DSBSC modulation and demodulation and study its spectral characteristics
//Analog and Digital Communication Laboratory 
//B.Tech II Year II Sem
//Student Name:               Enrolment Number:  
// Course Instructor: Aqeel Shaik
// Sreyas Institute Of Engineering & Technology, Hyderabad.
//-------------------------------------------------------------------------------//


// OS : Windows 10.1
// Scilab 6.0.2

clc;
clear;
close;

fs=100
t=0:1/fs :3;
p=length(t);
fm=input('Enter the message signal frequency =');
fc=input('Enter the carrier signal frequency (fc>>>fm) =');
am=input('Enter the message signal amplitude =');
ac=input('Enter the carrier signal amplitude =');

// Message Signal Generation

msg=am*cos(2*%pi*fm*t); 

figure(1);
subplot(3,1,1);
plot(t,msg);
xlabel('TIME');
ylabel('AMPLITUDE')
title('Message Signal');

//Carrier Signal generation
carrier=ac*cos(2*%pi*fc*t);
subplot(3,1,2);
plot(t,carrier);
xlabel('TIME');
ylabel('AMPLITUDE')
title('Carrier Signal');

//DSBSC Modulation Generation

dsbsc_mod=msg.*carrier;
subplot(3,1,3);
plot(t,dsbsc_mod);
xlabel('TIME');
ylabel('AMPLITUDE')
title('Amplitude Modulated Signal')

// Frqeuncy Spectrum
d=(-p/2:1:p/2-1)*1/3;
figure(2)
subplot(3,1,1);
plot(d,abs(fftshift(fft(dsbsc_mod))));// FOURIER TRANSFORM OF MODULATED SIGNAL
xlabel('FREQUENCY');
ylabel('AMPLITUDE')
title('DSBSC Signal Spectrum')


//Demodulation of DSBSC Signal
demod=dsbsc_mod.*carrier;
k=abs(fft(demod));
filt = [ones(1,4*fm), zeros(1,p-4*fm) ];
out=k.*filt;
subplot(3,1,3);
plot(t,ifft(out));
xlabel('TIME');
ylabel('AMPLITUDE');
title('Demodulated Message')

// Sample Inputs for the Program

//Enter the message signal frequency =2

//Enter the carrier signal frequency (fc>>>fm) =20

//Enter the message signal amplitude =1

//Enter the carrier signal amplitude =2



